<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
  <!-- Stats Grid -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-users"></i> Total Users</div>
      <div class="stat-value"><?php echo e($stats['total_users']); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-user-check"></i> Active Users (24h)</div>
      <div class="stat-value"><?php echo e($stats['active_users']); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-download"></i> Total Deposits</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['total_deposits'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-upload"></i> Total Withdrawals</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['total_withdrawals'], 2, ',', '.')); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-clock"></i> Pending Deposits</div>
      <div class="stat-value"><?php echo e($stats['pending_deposits']); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-hourglass-half"></i> Pending Withdrawals</div>
      <div class="stat-value"><?php echo e($stats['pending_withdrawals']); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-gamepad"></i> Total Game Rounds</div>
      <div class="stat-value"><?php echo e($stats['total_game_rounds']); ?></div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Total Revenue</div>
      <div class="stat-value">R$ <?php echo e(number_format($stats['total_revenue'], 2, ',', '.')); ?></div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="recent-users" onclick="switchTab('recent-users', this)">
        <i class="fas fa-users"></i> Recent Users
      </button>
      <button class="tab-btn" data-tab="recent-deposits" onclick="switchTab('recent-deposits', this)">
        <i class="fas fa-money-bill-wave"></i> Recent Deposits
      </button>
      <button class="tab-btn" data-tab="recent-withdrawals" onclick="switchTab('recent-withdrawals', this)">
        <i class="fas fa-money-check-alt"></i> Recent Withdrawals
      </button>
    </div>

    <!-- Recent Users Tab -->
    <div id="recent-users" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>Name</th>
              <th>Email</th>
              <th>Joined</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $recent_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($user->id); ?></td>
                <td><?php echo e($user->name); ?></td>
                <td><?php echo e($user->email); ?></td>
                <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="4">No users found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Recent Deposits Tab -->
    <div id="recent-deposits" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $recent_deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($deposit->id); ?></td>
                <td><?php echo e($deposit->name); ?></td>
                <td>R$ <?php echo e(number_format($deposit->amount, 2, ',', '.')); ?></td>
                <td>
                  <?php if($deposit->status == 1): ?>
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  <?php elseif($deposit->status == 0): ?>
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  <?php else: ?>
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="4">No deposits found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Recent Withdrawals Tab -->
    <div id="recent-withdrawals" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>User</th>
              <th>Amount</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $recent_withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td>#<?php echo e($withdrawal->id); ?></td>
                <td><?php echo e($withdrawal->name); ?></td>
                <td>R$ <?php echo e(number_format($withdrawal->amount, 2, ',', '.')); ?></td>
                <td>
                  <?php if($withdrawal->status == 1): ?>
                    <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Approved</span>
                  <?php elseif($withdrawal->status == 0): ?>
                    <span class="status-badge status-pending"><i class="fas fa-clock"></i> Pending</span>
                  <?php else: ?>
                    <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Rejected</span>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="4">No withdrawals found</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      // Hide all tab contents
      document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.remove('active');
      });

      // Remove active class from all buttons
      document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.classList.remove('active');
      });

      // Show selected tab content
      document.getElementById(tabId).classList.add('active');

      // Add active class to clicked button
      button.classList.add('active');
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>