<?php $__env->startSection('title', 'Settings'); ?>

<?php $__env->startSection('content'); ?>
  <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 20px; margin-bottom: 30px;">
    <!-- General Settings -->
    <div class="card">
      <div class="card-title"><i class="fas fa-cogs"></i> General Settings</div>
      <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-globe"></i> Site Name</label>
          <input type="text" name="site_name" value="<?php echo e($settings['site_name']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-dollar-sign"></i> Default Currency</label>
          <input type="text" name="default_currency" value="<?php echo e($settings['default_currency']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-tools"></i> Maintenance Mode</label>
          <select name="maintenance_mode" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="0" <?php echo e(!$settings['maintenance_mode'] ? 'selected' : ''); ?>>Disabled</option>
            <option value="1" <?php echo e($settings['maintenance_mode'] ? 'selected' : ''); ?>>Enabled</option>
          </select>
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-user-plus"></i> Registration Enabled</label>
          <select name="registration_enabled" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
            <option value="1" <?php echo e($settings['registration_enabled'] ? 'selected' : ''); ?>>Enabled</option>
            <option value="0" <?php echo e(!$settings['registration_enabled'] ? 'selected' : ''); ?>>Disabled</option>
          </select>
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Settings</button>
      </form>
    </div>

    <!-- Financial Settings -->
    <div class="card">
      <div class="card-title"><i class="fas fa-coins"></i> Financial Settings</div>
      <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-arrow-down"></i> Minimum Deposit (R$)</label>
          <input type="number" step="0.01" name="min_deposit" value="<?php echo e($settings['min_deposit']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-arrow-up"></i> Maximum Deposit (R$)</label>
          <input type="number" step="0.01" name="max_deposit" value="<?php echo e($settings['max_deposit']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-download"></i> Minimum Withdrawal (R$)</label>
          <input type="number" step="0.01" name="min_withdrawal" value="<?php echo e($settings['min_withdrawal']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-upload"></i> Maximum Withdrawal (R$)</label>
          <input type="number" step="0.01" name="max_withdrawal" value="<?php echo e($settings['max_withdrawal']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <div style="margin-bottom: 15px;">
          <label style="display: block; margin-bottom: 5px; font-weight: 500;"><i class="fas fa-percentage"></i> Withdrawal Fee (%)</label>
          <input type="number" step="0.01" name="withdrawal_fee" value="<?php echo e($settings['withdrawal_fee']); ?>" required style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #f1f5f9;">
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Settings</button>
      </form>
    </div>
  </div>

  <div class="card">
    <div class="card-title"><i class="fas fa-info-circle"></i> Current Configuration</div>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
      <div>
        <strong style="display: block; margin-bottom: 5px;">Site Name:</strong>
        <span><?php echo e($settings['site_name']); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Currency:</strong>
        <span><?php echo e($settings['default_currency']); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Maintenance Mode:</strong>
        <span class="status-badge <?php echo e($settings['maintenance_mode'] ? 'status-error' : 'status-success'); ?>">
          <?php echo e($settings['maintenance_mode'] ? 'Enabled' : 'Disabled'); ?>

        </span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Registration:</strong>
        <span class="status-badge <?php echo e($settings['registration_enabled'] ? 'status-success' : 'status-error'); ?>">
          <?php echo e($settings['registration_enabled'] ? 'Enabled' : 'Disabled'); ?>

        </span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Min Deposit:</strong>
        <span>R$ <?php echo e(number_format($settings['min_deposit'], 2, ',', '.')); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Max Deposit:</strong>
        <span>R$ <?php echo e(number_format($settings['max_deposit'], 2, ',', '.')); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Min Withdrawal:</strong>
        <span>R$ <?php echo e(number_format($settings['min_withdrawal'], 2, ',', '.')); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Max Withdrawal:</strong>
        <span>R$ <?php echo e(number_format($settings['max_withdrawal'], 2, ',', '.')); ?></span>
      </div>
      <div>
        <strong style="display: block; margin-bottom: 5px;">Withdrawal Fee:</strong>
        <span><?php echo e($settings['withdrawal_fee']); ?>%</span>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/admin/settings.blade.php ENDPATH**/ ?>