<div class="modal" id="gameRulesModal">
  <div class="modal-overlay"></div>
  <div class="modal-container modal-container-large">
    <div class="modal-header game-rules-header">
      <h2>GAME RULES</h2>
      <button class="modal-close" onclick="closeModal('gameRulesModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body game-rules-body">
      <!-- Game Rules Introduction -->
      <div class="rules-intro">
        <p>Aviator is a new generation of iGaming entertainment. You can win many times more, in seconds! Aviator is built on a provably fair system, which is currently the only real guarantee of honesty in the gambling industry.</p>
        <a href="#" class="provably-fair-link" onclick="event.preventDefault();">Read more about provably fair system</a>
      </div>

      <!-- How To Play Video Section -->
      <div class="rules-video-section">
        <h3>HOW TO PLAY</h3>
        <div class="video-container">
          <iframe 
            id="gameRulesVideo"
            width="100%" 
            height="100%" 
            src="https://www.youtube.com/embed/dQw4w9WgXcQ" 
            frameborder="0" 
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
            allowfullscreen
            style="min-height: 400px;">
          </iframe>
        </div>
      </div>

      <!-- Easy Steps Section -->
      <div class="easy-steps-section">
        <h3>Aviator is as easy to play as 1-2-3:</h3>
        <div class="steps-grid">
          <div class="step-item">
            <div class="step-number">01</div>
            <img src="<?php echo e(asset('assets/01.png')); ?>" alt="Bet step" class="step-image" onerror="this.style.display='none'">
          </div>
          <div class="step-item">
            <div class="step-number">02</div>
            <img src="<?php echo e(asset('assets/02.png')); ?>" alt="Watch step" class="step-image" onerror="this.style.display='none'">
          </div>
          <div class="step-item">
            <div class="step-number">03</div>
            <img src="<?php echo e(asset('assets/03.png')); ?>" alt="Cash out step" class="step-image" onerror="this.style.display='none'">
          </div>
        </div>
        <p class="warning-text">But remember, if you did not have time to Cash Out before the Lucky Plane flies away, your bet will be lost. Aviator is pure excitement! Risk and win. It's all in your hands!</p>
      </div>

      <!-- More Details Section -->
      <div class="more-details-section">
        <h3>More details</h3>
        <ul class="details-list">
          <li>The win multiplier starts at 1x and grows more and more as the Lucky Plane takes off.</li>
          <li>Your winnings are calculated at the multiplier at which you made a Cash Out, multiplied by your bet.</li>
          <li>Before the start of each round, our provably fair random number generator generates the multiplier at which the Lucky Plane will fly away. You can check the honesty of this generation by clicking on the <span class="icon-placeholder">✓</span> icon in the Top tab.</li>
        </ul>
      </div>

      <!-- Game Functions Section -->
      <div class="game-functions-section">
        <h3>GAME FUNCTIONS</h3>
        
        <div class="function-subsection">
          <h4>Bet & Cash Out:</h4>
          <ul>
            <li>Select an amount and press the "Bet" button to make a bet.</li>
            <li>You can cancel the bet by pressing the "Cancel" button if the round has not yet started.</li>
            <li>Adjust the bet size using the "+" and "-" buttons to change the bet amount. Alternatively, you can select the bet size using the preset values or enter a value manually.</li>
            <li>You can make two bets simultaneously, by adding a second bet panel. To add a second bet panel, press the plus icon, which is located on the top right corner of the first bet panel.</li>
            <li>Press the "Cash Out" button to cash out your winnings. Your win is your bet multiplied by the Cash Out multiplier.</li>
            <li>Your bet is lost, if you didn't cash out before the plane flies away.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Auto Play & Auto Cash Out:</h4>
          <ul>
            <li>Before starting Auto Play, select the bet size you want to play with. How to do this is described in the Bet & cash out section.</li>
            <li>Auto Play is activated from the "Auto" tab in the Bet Panel, by checking the "Auto Bet" checkbox. After activation, bets will be placed automatically, but for Cash Out, you should press the "Cash Out" button in each round. If you want the bet to cash out automatically, then use the "Auto Cash Out" option.</li>
            <li>Auto Cash Out is available from the "Auto" tab on the Bet panel. After activation, your bet will be automatically cashed out when it reaches the multiplier entered.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Live Bets & Statistics:</h4>
          <ul>
            <li>On the left side of the game interface (or under the Bet Panel on mobile), is located the Live Bets panel. Here you can see all bets that are being made in the current round.</li>
            <li>In the "Top" panel, game statistics are located. You can browse wins by amount, or Cash Out multiplier, and see the biggest round multipliers.</li>
            <li>Share round results by clicking the <span class="icon-placeholder">💬</span> icon and pasting into the chat.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>In-Game Chat:</h4>
          <ul>
            <li>On the right side of the game interface (or after pressing the Chat icon, on the top right corner of the mobile interface), the Chat Panel is located. In Chat, you can communicate with other players. Also, information about huge wins is posted in the Chat automatically.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Free Bets:</h4>
          <ul>
            <li>You can check the status of Free Bets, from the Game Menu > Free Bets. Free Bets are awarded by the operator, or by the Rain Feature.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Rain Feature:</h4>
          <ul>
            <li>The operator can drop Free Bets into the chat, which can be claimed by pressing the "Claim" button when they appear.</li>
            <li>Players can also share Free Bets with others using the "Rain" panel by pressing the "Rain" button at the bottom of the chat, allowing other players to claim them.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Randomisation:</h4>
          <ul>
            <li>The multiplier for each round is generated by a "Provably Fair" algorithm, described as completely transparent and 100% fair. <a href="#" class="inline-link">Read more about provably fair system</a></li>
            <li>Users can check and modify Provably Fair settings from "Game menu > Provably Fair settings."</li>
            <li>Users can check the fairness of each round by pressing a check mark icon, located opposite results in the "My Bets" or "Top" tabs.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Game Menu:</h4>
          <ul>
            <li>Accessing the game menu by tapping the menu button in the top right corner of the screen.</li>
            <li>Toggling "Sound" and "Music" switches to turn game sounds and background music on or off.</li>
            <li>Toggling the "Animation" switch to turn the "airplane animation" on or off.</li>
            <li>Pressing the "Limits" button to view minimum/maximum bets and the maximum win limit.</li>
            <li>Pressing the "My Bets History" button to view past bets.</li>
            <li>Opening "Game Rules" to read detailed rules of the game.</li>
          </ul>
        </div>

        <div class="function-subsection">
          <h4>Other:</h4>
          <ul>
            <li>If the internet connection is interrupted during an active bet, the game will automatically cash out at the current multiplier, and winnings will be added to the balance.</li>
            <li>In case of a malfunction in gaming hardware/software, all affected game bets and payouts are voided, and all affected bets are refunded.</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.game-rules-header {
  background: #1a1a2e;
  color: #fff;
  border-bottom: 1px solid #2a2a3e;
}

.game-rules-header h2 {
  color: #fff;
  font-weight: 700;
  text-transform: uppercase;
}

.game-rules-body {
  padding: 24px;
  max-height: 80vh;
  overflow-y: auto;
  overflow-x: hidden;
  background: #1A1A1A;
  color: #fff;
  /* Hide scrollbar but allow scrolling */
  scrollbar-width: none; /* Firefox */
  -ms-overflow-style: none; /* IE and Edge */
}

.game-rules-body::-webkit-scrollbar {
  display: none; /* Chrome, Safari, Opera */
}

.rules-intro {
  margin-bottom: 32px;
  padding-bottom: 24px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.rules-intro p {
  color: #fff;
  font-size: 14px;
  line-height: 1.6;
  margin-bottom: 16px;
}

.provably-fair-link {
  color: #ff6b6b;
  text-decoration: underline;
  font-size: 14px;
  transition: color 0.2s;
}

.provably-fair-link:hover {
  color: #ff4444;
}

.rules-video-section {
  margin-bottom: 32px;
  padding-bottom: 24px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.rules-video-section h3 {
  color: #fff;
  font-size: 18px;
  font-weight: 700;
  margin-bottom: 16px;
}

.rules-video-section .video-container {
  width: 100%;
  height: 100%;
  min-height: 400px;
  background: #1a1a1a;
  border-radius: 8px;
  overflow: hidden;
  position: relative;
}

.rules-video-section .video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
}

.easy-steps-section {
  margin-bottom: 32px;
  padding-bottom: 24px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.easy-steps-section h3 {
  color: #fff;
  font-size: 18px;
  font-weight: 700;
  margin-bottom: 24px;
}

.steps-grid {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 20px;
  margin-bottom: 24px;
}

.step-item {
  text-align: center;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 8px;
}

.step-number {
  font-size: 24px;
  font-weight: 700;
  color: #ff6b6b;
  line-height: 1;
  margin-bottom: 4px;
}

.step-image {
  width: 100%;
  max-width: 300px;
  height: auto;
  min-height: 220px;
  object-fit: contain;
  display: block;
  background: transparent;
}

.warning-text {
  color: #ff6b6b;
  font-size: 13px;
  line-height: 1.6;
  text-align: center;
  padding: 16px;
  background: rgba(255, 107, 107, 0.1);
  border-radius: 8px;
  margin-top: 16px;
}

.more-details-section,
.game-functions-section {
  margin-bottom: 32px;
}

.more-details-section h3,
.game-functions-section h3 {
  color: #fff;
  font-size: 18px;
  font-weight: 700;
  margin-bottom: 16px;
}

.details-list,
.function-subsection ul {
  list-style: none;
  padding: 0;
  margin: 0 0 24px 0;
}

.details-list li,
.function-subsection ul li {
  color: #ccc;
  font-size: 14px;
  line-height: 1.8;
  padding-left: 24px;
  position: relative;
  margin-bottom: 12px;
}

.details-list li:before,
.function-subsection ul li:before {
  content: "•";
  color: #ff6b6b;
  font-weight: bold;
  position: absolute;
  left: 0;
}

.function-subsection {
  margin-bottom: 24px;
  padding-bottom: 24px;
  border-bottom: 1px solid rgba(255, 255, 255, 0.08);
}

.function-subsection:last-child {
  border-bottom: none;
  margin-bottom: 0;
  padding-bottom: 0;
}

.function-subsection h4 {
  color: #fff;
  font-size: 16px;
  font-weight: 600;
  margin-bottom: 12px;
}

.inline-link {
  color: #ff6b6b;
  text-decoration: underline;
}

.icon-placeholder {
  color: #12DF38;
  font-weight: bold;
}

@media (max-width: 768px) {
  .steps-grid {
    grid-template-columns: 1fr;
    gap: 20px;
  }
  
  .step-image {
    max-width: 100%;
    min-height: 200px;
  }
  
  .rules-video-section .video-container {
    min-height: 250px;
  }
  
  .game-rules-body {
    padding: 16px;
  }
}
</style>
<?php /**PATH /Users/iksoft/Downloads/painelaviator.online/resources/views/modals/game-rules.blade.php ENDPATH**/ ?>