<div class="modal" id="howToPlayModal">
  <div class="modal-overlay"></div>
  <div class="modal-container modal-container-large">
    <div class="modal-header how-to-play-header">
      <h2>HOW TO PLAY?</h2>
      <button class="modal-close" onclick="closeModal('howToPlayModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body how-to-play-body">
      <!-- Video Section -->
      <div class="video-section">
        <div class="video-container">
          <iframe 
            id="howToPlayVideo"
            width="100%" 
            height="100%" 
            src="https://www.youtube.com/embed/dQw4w9WgXcQ" 
            frameborder="0" 
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
            allowfullscreen
            style="min-height: 400px;">
          </iframe>
        </div>
      </div>
      
      <!-- Instructions Section -->
      <div class="instructions-section">
        <div class="instruction-item">
          <div class="instruction-number">01</div>
          <div class="instruction-content">
            <img src="<?php echo e(asset('assets/h1.png')); ?>" alt="Bet instruction" class="instruction-image" onerror="this.style.display='none'">
            <p class="instruction-text">Make a bet, or even two at same time and wait for the round to start.</p>
          </div>
        </div>
        
        <div class="instruction-item">
          <div class="instruction-number">02</div>
          <div class="instruction-content">
            <img src="<?php echo e(asset('assets/h2.png')); ?>" alt="Watch instruction" class="instruction-image" onerror="this.style.display='none'">
            <p class="instruction-text">Look after the lucky plane. Your win is bet multiplied by a coefficient of lucky plane.</p>
          </div>
        </div>
        
        <div class="instruction-item">
          <div class="instruction-number">03</div>
          <div class="instruction-content">
            <img src="<?php echo e(asset('assets/h3.png')); ?>" alt="Cash out instruction" class="instruction-image" onerror="this.style.display='none'">
            <p class="instruction-text">Cash Out before plane flies away and money is yours!</p>
          </div>
        </div>
        
        <div class="detailed-rules-link">
          <a href="#" onclick="event.preventDefault(); closeModal('howToPlayModal'); setTimeout(() => openModal('gameRulesModal'), 300);">detailed rules</a>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.how-to-play-header {
  background: #CFAB38;
  color: #fff;
  border-bottom: none;
}

.how-to-play-header h2 {
  color: #fff;
  font-weight: 700;
  text-transform: uppercase;
}

.how-to-play-body {
  padding: 0;
}

.video-section {
  background: #2a2a2a;
  padding: 20px;
  min-height: 400px;
}

.video-container {
  width: 100%;
  height: 100%;
  min-height: 400px;
  background: #1a1a1a;
  border-radius: 8px;
  overflow: hidden;
  position: relative;
}

.video-container iframe {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
}

.instructions-section {
  background: #CFAB38;
  padding: 24px;
}

.instruction-item {
  display: flex;
  align-items: flex-start;
  gap: 16px;
  margin-bottom: 20px;
  padding: 0;
}

.instruction-item:last-of-type {
  margin-bottom: 16px;
}

.instruction-number {
  font-size: 32px;
  font-weight: 700;
  color: rgba(0, 0, 0, 0.7);
  line-height: 1;
  min-width: 50px;
  padding-top: 4px;
}

.instruction-content {
  flex: 1;
  display: flex;
  align-items: center;
  gap: 12px;
}

.instruction-image {
  width: 60px;
  height: 60px;
  object-fit: contain;
  flex-shrink: 0;
}

.instruction-content .instruction-text {
  color: #000;
  font-size: 14px;
  font-weight: 500;
  margin: 0;
  line-height: 1.5;
  flex: 1;
}

.detailed-rules-link {
  text-align: center;
  margin-top: 20px;
  padding-top: 20px;
  border-top: 1px solid rgba(0, 0, 0, 0.2);
}

.detailed-rules-link a {
  color: rgba(0, 0, 0, 0.8);
  text-decoration: underline;
  font-size: 14px;
  font-weight: 600;
  cursor: pointer;
  transition: color 0.2s;
}

.detailed-rules-link a:hover {
  color: #000;
}

.modal-container-large {
  max-width: 900px;
}

.how-to-play-body {
  /* Hide scrollbar but allow scrolling */
  scrollbar-width: none; /* Firefox */
  -ms-overflow-style: none; /* IE and Edge */
}

.how-to-play-body::-webkit-scrollbar {
  display: none; /* Chrome, Safari, Opera */
}

@media (max-width: 768px) {
  .instruction-item {
    flex-direction: column;
    text-align: center;
  }
  
  .instruction-number {
    min-width: auto;
  }
  
  .instruction-content {
    flex-direction: column;
    text-align: center;
  }
  
  .video-container {
    min-height: 250px;
  }
}
</style>
<?php /**PATH C:\Users\aduam\Documents\GitHub\aviator_clone_complete\upgrade\aviator_crash\resources\views/modals/how-to-play.blade.php ENDPATH**/ ?>