<div class="modal" id="profileModal">
  <div class="modal-overlay"></div>
  <div class="modal-container">
    <div class="modal-header">
      <h2>Update Profile</h2>
      <button class="modal-close" onclick="closeModal('profileModal')">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </div>
    <div class="modal-body">
      <form id="profileForm" onsubmit="handleProfileUpdate(event)">
        <?php echo csrf_field(); ?>
        <div class="form-group">
          <label for="profileName">Full Name</label>
          <input type="text" id="profileName" name="name" value="<?php echo e(auth()->user()->name); ?>" required>
        </div>
        
        <div class="form-group">
          <label for="profileEmail">Email</label>
          <input type="email" id="profileEmail" name="email" value="<?php echo e(auth()->user()->email); ?>" required>
        </div>
        
        <div class="form-group">
          <label for="profilePhone">Phone</label>
          <input type="text" id="profilePhone" name="phone" value="<?php echo e(auth()->user()->phone ?? ''); ?>" placeholder="Enter your phone number">
        </div>
        
        <div class="form-group">
          <label for="profileCpf">CPF</label>
          <input type="text" id="profileCpf" name="cpf" value="<?php echo e(auth()->user()->cpf ?? ''); ?>" placeholder="Enter your CPF">
        </div>
        
        <div class="form-group">
          <label for="currentPassword">Current Password (to change password)</label>
          <input type="password" id="currentPassword" name="current_password" placeholder="Enter current password">
        </div>
        
        <div class="form-group">
          <label for="newPassword">New Password</label>
          <input type="password" id="newPassword" name="password" placeholder="Enter new password (min. 6 characters)">
        </div>
        
        <div class="form-group">
          <label for="confirmPassword">Confirm New Password</label>
          <input type="password" id="confirmPassword" name="password_confirmation" placeholder="Confirm new password">
        </div>
        
        <div class="modal-footer">
          <button type="button" class="btn-secondary" onclick="closeModal('profileModal')">Cancel</button>
          <button type="submit" class="btn-primary">Update Profile</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  function handleProfileUpdate(e) {
    e.preventDefault();
    const formData = new FormData(e.target);
    const data = Object.fromEntries(formData);
    
    // Only include password fields if new password is provided
    if (!data.password) {
      delete data.password;
      delete data.password_confirmation;
      delete data.current_password;
    }
    
    const submitBtn = e.target.querySelector('button[type="submit"]');
    const originalText = submitBtn.textContent;
    submitBtn.disabled = true;
    submitBtn.textContent = 'Updating...';
    
    fetch('/profile/update', {
      method: 'POST',
      headers: {
        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
      },
      credentials: 'same-origin',
      body: JSON.stringify(data)
    })
    .then(async response => {
      // Check if response is JSON
      const contentType = response.headers.get('content-type');
      if (contentType && contentType.includes('application/json')) {
        return response.json();
      } else {
        // If not JSON, get text and try to parse or show error
        const text = await response.text();
        console.error('Non-JSON response:', text);
        throw new Error('Server returned an error. Please check the console for details.');
      }
    })
    .then(data => {
      if (data.success) {
        alert('Profile updated successfully!');
        closeModal('profileModal');
        location.reload(); // Reload to show updated info
      } else {
        const errorMsg = data.message || data.errors ? JSON.stringify(data.errors || data.message) : 'Failed to update profile';
        alert(errorMsg);
      }
    })
    .catch(error => {
      console.error('Profile update error:', error);
      alert('An error occurred. Please try again. ' + (error.message || ''));
    })
    .finally(() => {
      submitBtn.disabled = false;
      submitBtn.textContent = originalText;
    });
  }
</script>
<?php /**PATH C:\Users\aduam\Documents\GitHub\aviator_clone_complete\upgrade\aviator_crash\resources\views/modals/profile.blade.php ENDPATH**/ ?>