<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Aviator Game</title>
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link href="https://fonts.googleapis.com/css2?family=Oswald:wght@700&family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('css/styles.css')); ?>">
  
</head>
<body>
  <!-- Loader -->
  <div class="loader-container" id="loader">
    <div class="loader">
      <div class="powered">POWERED BY</div>
      <div class="logo">SPRIBE</div>
      <div class="dots">
        <div class="dot"></div>
        <div class="dot"></div>
        <div class="dot"></div>
      </div>
    </div>
  </div>

  <!-- Main Game Interface -->
  <div class="game-container" id="gameContainer">
    <!-- Header -->
    <div class="header">
      <div class="logo">Aviator</div>
      <div class="balance">
        <?php if(auth()->guard()->check()): ?>
          <div class="balance-info">
            <span>Balance: <span class="balance-amount" id="userBalance"><?php echo e(auth()->user()->formatted_balance); ?></span> R$</span>
            <span class="user-name"><?php echo e(auth()->user()->name); ?></span>
          </div>
          <div class="user-menu-container">
            <div class="menu-icon" id="userMenuIcon">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                  <path d="M3 12h18M3 6h18M3 18h18"/>
                </svg>
            </div>
            <div class="user-menu-dropdown" id="userMenuDropdown">
              <!-- User Profile Section -->
              <div class="user-profile-section">
                <div class="user-avatar-container">
                  <div class="user-avatar" id="userAvatar" style="background-image: url('<?php echo e(auth()->user()->avatar ?? 'https://ui-avatars.com/api/?name=' . urlencode(auth()->user()->name) . '&background=random'); ?>')">
                  </div>
                  <div class="user-info">
                    <div class="user-username"><?php echo e(auth()->user()->name); ?></div>
                  </div>
                  <button class="change-avatar-btn" onclick="event.preventDefault(); openModal('avatarModal');">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                      <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                      <circle cx="12" cy="7" r="4"/>
                    </svg>
                  </button>
                </div>
              </div>
              
              <!-- Settings Toggles -->
              <div class="settings-section">
                <div class="setting-toggle-item">
                  <div class="setting-toggle-label">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                      <polygon points="11 5 6 9 2 9 2 15 6 15 11 19 11 5"/>
                      <path d="M19.07 4.93a10 10 0 0 1 0 14.14M15.54 8.46a5 5 0 0 1 0 7.07"/>
                    </svg>
                    <span>Sound</span>
                  </div>
                  <label class="toggle-switch">
                    <input type="checkbox" id="soundToggle" checked>
                    <span class="toggle-slider"></span>
                  </label>
                </div>
                <div class="setting-toggle-item">
                  <div class="setting-toggle-label">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                      <path d="M9 18V5l12-2v13"/>
                      <circle cx="6" cy="18" r="3"/>
                      <circle cx="18" cy="16" r="3"/>
                    </svg>
                    <span>Music</span>
                  </div>
                  <label class="toggle-switch">
                    <input type="checkbox" id="musicToggle" checked>
                    <span class="toggle-slider"></span>
                  </label>
                </div>
                <div class="setting-toggle-item">
                  <div class="setting-toggle-label">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                      <circle cx="12" cy="12" r="10"/>
                      <path d="M12 6v6l4 2"/>
                    </svg>
                    <span>Animation</span>
                  </div>
                  <label class="toggle-switch">
                    <input type="checkbox" id="animationToggle" checked>
                    <span class="toggle-slider"></span>
                  </label>
                </div>
              </div>
              
              <!-- Menu Items -->
              <div class="menu-items-section">
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('topupModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M12 2v20M2 12h20"/>
                  </svg>
                  <span>Topup Account</span>
                </a>
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('profileModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                    <circle cx="12" cy="7" r="4"/>
                  </svg>
                  <span>Update Profile</span>
                </a>
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('withdrawModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4M17 8l-5-5-5 5M12 3v12"/>
                  </svg>
                  <span>Withdraw</span>
                </a>
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('historyModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <polyline points="12 6 12 12 16 14"/>
                    <path d="M12 18h.01"/>
                  </svg>
                  <span>My Bet History</span>
                </a>
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('howToPlayModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <circle cx="12" cy="12" r="10"/>
                    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/>
                    <path d="M12 17h.01"/>
                  </svg>
                  <span>How To Play</span>
                </a>
                <a href="#" class="menu-item" onclick="event.preventDefault(); openModal('gameRulesModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                    <polyline points="14 2 14 8 20 8"/>
                    <line x1="16" y1="13" x2="8" y2="13"/>
                    <line x1="16" y1="17" x2="8" y2="17"/>
                    <polyline points="10 9 9 9 8 9"/>
                  </svg>
                  <span>Game Rules</span>
                </a>
                <div class="menu-divider"></div>
                <a href="#" class="menu-item menu-item-danger" onclick="event.preventDefault(); openModal('logoutModal');">
                  <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4M16 17l5-5-5-5M21 12H9"/>
                  </svg>
                  <span>Logout</span>
                </a>
              </div>
            </div>
          </div>
        <?php else: ?>
          <div class="guest-links">
            <a href="<?php echo e(route('login')); ?>">Login</a> | 
            <a href="<?php echo e(route('register')); ?>">Register</a>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <div class="main-content" id="mainContent">
      <!-- Mobile Sidebar Toggle -->
      <div class="sidebar-toggle-mobile" id="sidebarMenuIcon" style="display: none;">
        <span></span>
        <span></span>
        <span></span>
      </div>
      <!-- Sidebar -->
      <div class="sidebar" id="sidebar">
        <!-- Tabs -->
        <div class="tabs">
          <button class="tab active" data-tab="all-bets">All Bets</button>
          <button class="tab" data-tab="previous">Previous</button>
          <button class="tab" data-tab="top">Top</button>
        </div>

        <!-- Tab Content: All Bets -->
        <div class="tab-content active" id="all-bets-content">
          <!-- Stats -->
          <div class="stats">
              <div class="stats-row">
                  <div class="stats-info">
                      <div class="stats-header">
                          <div class="players-icon stats-icons">
                              <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=user1')"></div>
                              <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=user2')"></div>
                              <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=user3')"></div>
                          </div>
                          <div class="stats-text">536/669 Bets</div>
                      </div>
                      <div class="stats-progress">
                          <div class="stats-progress-inner" style="width: 80.1%;"></div>
                      </div>
                  </div>
                  <div class="stats-win">
                      <div class="stats-number">1,286.51</div>
                      <div class="stats-text">Total win R$</div>
                  </div>
              </div>
          </div>

          <div class="bets-header">
              <span>Player</span>
              <span>Bet R$</span>
              <span>X</span>
              <span>Win R$</span>
          </div>

          <!-- Bets List -->
          <div class="bets-list" id="all-bets-list">
          </div>
        </div>

        <!-- Tab Content: Previous -->
        <div class="tab-content" id="previous-content">
          <div class="round-result-header" id="round-result-header">
            <div class="round-result-label">Round Result</div>
            <div class="round-result-multiplier" id="round-result-multiplier">2.24x</div>
          </div>
          <div class="previous-bets-header">
            <span>Player</span>
            <span>Bet R$</span>
            <span>X</span>
            <span>Win R$</span>
          </div>
          <div class="previous-rounds-list" id="previous-rounds-list">
          </div>
        </div>

        <!-- Tab Content: Top -->
        <div class="tab-content" id="top-content">
          <div class="top-filters">
            <div class="filter-row">
              <button class="filter-btn active" data-filter="x">X</button>
              <button class="filter-btn" data-filter="win">Win</button>
              <button class="filter-btn" data-filter="rounds">Rounds</button>
            </div>
            <div class="filter-row">
              <button class="filter-btn active" data-filter="day">Day</button>
              <button class="filter-btn" data-filter="month">Month</button>
              <button class="filter-btn" data-filter="year">Year</button>
            </div>
          </div>
          <div class="top-winners-list" id="top-winners-list">
          </div>
        </div>
        
        <div class="sidebar-footer">
            <div class="provably-fair">
                <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path></svg>
                <span>Provably Fair Game</span>
            </div>
            <div class="powered-by">Powered by <span>SPRIBE</span></div>
        </div>
      </div>

      <div class="main-column">
        <!-- Multipliers -->
        <div class="multipliers">
          <span class="multiplier red">5.78x</span>
          <span class="multiplier blue">1.29x</span>
          <span class="multiplier blue">1.09x</span>
          <span class="multiplier blue">1.76x</span>
          <span class="multiplier purple">2.21x</span>
          <span class="multiplier purple">5.27x</span>
          <span class="multiplier blue">1.18x</span>
          <span class="multiplier blue">1.29x</span>
          <span class="multiplier blue">1.09x</span>
          <span class="multiplier blue">1.76x</span>
          <span class="multiplier purple">2.21x</span>
          <span class="multiplier purple">5.27x</span>
          <span class="multiplier blue">1.18x</span>
          <span class="multiplier blue">1.43x</span>
          <span class="multiplier purple">2.63x</span>
          <span class="multiplier blue">1.56x</span>
          <span class="multiplier blue">1.15x</span>
          <span class="multiplier blue">1.40x</span>
          <span class="multiplier blue">1.92x</span>
          <span class="multiplier purple">2.08x</span>
          <span class="multiplier red">3.22x</span>
          <span class="multiplier blue">1.43x</span>
          <span class="multiplier purple">2.63x</span>
          <span class="multiplier blue">1.29x</span>
          <span class="multiplier blue">1.09x</span>
          <span class="multiplier blue">1.76x</span>
          <span class="multiplier purple">2.21x</span>
          <span class="multiplier purple">5.27x</span>
          <span class="multiplier blue">1.18x</span>
          <span class="multiplier blue">1.43x</span>
          <span class="multiplier purple">2.63x</span>
          <span class="multiplier blue">1.56x</span>
          <span class="multiplier blue">1.15x</span>
          <span class="multiplier blue">1.40x</span>
          <span class="multiplier blue">1.92x</span>
          <span class="multiplier purple">2.08x</span>
          <span class="multiplier red">3.22x</span>
          <span class="multiplier blue">1.56x</span>
          <span class="multiplier blue">1.15x</span>
          <span class="multiplier blue">1.40x</span>
          <span class="multiplier blue">1.92x</span>
          <span class="multiplier purple">2.08x</span>
          <span class="multiplier red">3.22x</span>
          <span class="multiplier blue">1.59x</span>
          <span class="multiplier-more">...</span>
        </div>
          
        <!-- Game Area -->
        <div class="game-area">
          <div class="dark-overlay"></div>
          
          <canvas id="gameCanvas"></canvas>
          <img id="plane" src="<?php echo e(asset('assets/plane-0.svg')); ?>" class="game-plane">
          
          <!-- Flying/Flew Away Phase -->
          <div class="flying-phase active" id="flyingPhase">
            <div class="flew-away" id="flewAwayText">FLEW AWAY!</div>
            <div class="multiplier-display" id="currentMultiplier">1.00x</div>
          </div>
          
          <!-- UFC Phase -->
          <div class="ufc-phase" id="ufcPhase">
            <div class="ufc-content">
              <img src="<?php echo e(asset('ufc.svg')); ?>" alt="UFC" class="ufc-phase-logo">
              <div class="ufc-progress-container">
                <div class="ufc-progress-bar"></div>
              </div>
              <img src="<?php echo e(asset('spribe.svg')); ?>" alt="Spribe" class="spribe-phase-logo">
            </div>
          </div>
          
          <div class="players-indicator">
            <div class="players-icon">
                <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=c')"></div>
                <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=d')"></div>
                <div class="avatar" style="background-image: url('https://i.pravatar.cc/24?u=e')"></div>
            </div>
            <span>235</span>
          </div>
        </div>
        
        <!-- Bottom Panel -->
        <div class="panels-wrapper">
          <!-- First Bet Panel -->
          <div class="betting-panel" data-panel-index="0">
            <div class="header">
              <div class="tab-container">
                <div class="tab active" data-tab="bet">Bet</div>
                <div class="tab inactive" data-tab="auto">Auto</div>
              </div>
            </div>
            <div class="main-content bet-content active">
              <div class="left-section">
                <div class="bet-control">
                  <button class="control-btn" onclick="changeBet(-1, 0)">−</button>
                  <div class="bet-amount">2.00</div>
                  <button class="control-btn" onclick="changeBet(1, 0)">+</button>
                </div>
                <div class="quick-bets">
                  <button class="quick-bet" onclick="setQuickBet(10, 0)">10</button>
                  <button class="quick-bet" onclick="setQuickBet(20, 0)">20</button>
                  <button class="quick-bet" onclick="setQuickBet(50, 0)">50</button>
                  <button class="quick-bet" onclick="setQuickBet(100, 0)">100</button>
                </div>
              </div>
              <button class="main-bet-btn" onclick="handleBetButtonClick(0)">
                <div class="bet-btn-text">Bet</div>
                <div class="bet-btn-amount">2.00 ZAR</div>
              </button>
            </div>
            <div class="main-content auto-content">
              <div class="top-section">
                <div class="left-section">
                  <div class="bet-control">
                    <button class="control-btn" onclick="changeBet(-1, 0)">−</button>
                    <div class="bet-amount">2.00</div>
                    <button class="control-btn" onclick="changeBet(1, 0)">+</button>
                  </div>
                  <div class="quick-bets">
                    <button class="quick-bet" onclick="setQuickBet(10, 0)">10</button>
                    <button class="quick-bet" onclick="setQuickBet(20, 0)">20</button>
                    <button class="quick-bet" onclick="setQuickBet(50, 0)">50</button>
                    <button class="quick-bet" onclick="setQuickBet(100, 0)">100</button>
                  </div>
                </div>
                <button class="main-bet-btn" onclick="handleBetButtonClick(0)">
                  <div class="bet-btn-text">Bet</div>
                  <div class="bet-btn-amount">2.00 ZAR</div>
                </button>
              </div>
              <div class="auto-controls">
                <div class="auto-toggle-row">
                  <div class="auto-toggle-item">
                    <label class="auto-toggle-label">Auto bet</label>
                    <label class="toggle-switch">
                      <input type="checkbox" class="auto-bet-toggle" data-panel="0">
                      <span class="toggle-slider"></span>
                    </label>
                  </div>
                  <div class="auto-toggle-item">
                    <label class="auto-toggle-label">Auto Cash Out</label>
                    <label class="toggle-switch">
                      <input type="checkbox" class="auto-cashout-toggle" data-panel="0">
                      <span class="toggle-slider"></span>
                    </label>
                    <div class="auto-cashout-input-wrapper">
                      <input type="number" class="auto-cashout-input" data-panel="0" value="1.10" step="0.01" min="1.01" placeholder="1.10">
                      <button type="button" class="auto-cashout-clear" data-panel="0" onclick="clearAutoCashoutInput(0)">×</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Second Bet Panel -->
          <div class="betting-panel" data-panel-index="1">
            <div class="header">
              <div class="tab-container">
                <div class="tab active" data-tab="bet">Bet</div>
                <div class="tab inactive" data-tab="auto">Auto</div>
              </div>
            </div>
            <div class="main-content bet-content active">
              <div class="left-section">
                <div class="bet-control">
                  <button class="control-btn" onclick="changeBet(-1, 1)">−</button>
                  <div class="bet-amount">2.00</div>
                  <button class="control-btn" onclick="changeBet(1, 1)">+</button>
                </div>
                <div class="quick-bets">
                  <button class="quick-bet" onclick="setQuickBet(10, 1)">10</button>
                  <button class="quick-bet" onclick="setQuickBet(20, 1)">20</button>
                  <button class="quick-bet" onclick="setQuickBet(50, 1)">50</button>
                  <button class="quick-bet" onclick="setQuickBet(100, 1)">100</button>
                </div>
              </div>
              <button class="main-bet-btn" onclick="handleBetButtonClick(1)">
                <div class="bet-btn-text">Bet</div>
                <div class="bet-btn-amount">2.00 ZAR</div>
              </button>
            </div>
            <div class="main-content auto-content">
              <div class="top-section">
                <div class="left-section">
                  <div class="bet-control">
                    <button class="control-btn" onclick="changeBet(-1, 1)">−</button>
                    <div class="bet-amount">2.00</div>
                    <button class="control-btn" onclick="changeBet(1, 1)">+</button>
                  </div>
                  <div class="quick-bets">
                    <button class="quick-bet" onclick="setQuickBet(10, 1)">10</button>
                    <button class="quick-bet" onclick="setQuickBet(20, 1)">20</button>
                    <button class="quick-bet" onclick="setQuickBet(50, 1)">50</button>
                    <button class="quick-bet" onclick="setQuickBet(100, 1)">100</button>
                  </div>
                </div>
                <button class="main-bet-btn" onclick="handleBetButtonClick(1)">
                  <div class="bet-btn-text">Bet</div>
                  <div class="bet-btn-amount">2.00 ZAR</div>
                </button>
              </div>
              <div class="auto-controls">
                <div class="auto-toggle-row">
                  <div class="auto-toggle-item">
                    <label class="auto-toggle-label">Auto bet</label>
                    <label class="toggle-switch">
                      <input type="checkbox" class="auto-bet-toggle" data-panel="1">
                      <span class="toggle-slider"></span>
                    </label>
                  </div>
                  <div class="auto-toggle-item">
                    <label class="auto-toggle-label">Auto Cash Out</label>
                    <label class="toggle-switch">
                      <input type="checkbox" class="auto-cashout-toggle" data-panel="1">
                      <span class="toggle-slider"></span>
                    </label>
                    <div class="auto-cashout-input-wrapper">
                      <input type="number" class="auto-cashout-input" data-panel="1" value="1.10" step="0.01" min="1.01" placeholder="1.10">
                      <button type="button" class="auto-cashout-clear" data-panel="1" onclick="clearAutoCashoutInput(1)">×</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      

      <!-- Chat Sidebar (visible on large screens) -->
      <div class="chat-sidebar">
        <div class="chat-header">
          <div class="chat-title">
            Rules
            <span class="chat-count">• 900</span>
          </div>
          <button class="chat-close">✕</button>
        </div>
        
        <div class="chat-messages">
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat1')"></div>
            <div class="chat-content">
              <div class="chat-username">5***6 Kubi</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">5</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat2')"></div>
            <div class="chat-content">
              <div class="chat-username">2***6</div>
              <div class="chat-text">Just want to recover then leave 🙏🙏</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">10</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat3')"></div>
            <div class="chat-content">
              <div class="chat-username">1***2 Kanti</div>
              <div class="chat-text">Whats happening today</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">6</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat4')"></div>
            <div class="chat-content">
              <div class="chat-username">3***3</div>
              <div class="chat-text">Unrecoverable 😭😭😭</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">10</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat5')"></div>
            <div class="chat-content">
              <div class="chat-username">1***5</div>
              <div class="chat-text">You can do this come on</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat6')"></div>
            <div class="chat-content">
              <div class="chat-username">1***7</div>
              <div class="chat-text">We will never recover like this</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">8</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat7')"></div>
            <div class="chat-content">
              <div class="chat-username">3***3</div>
              <div class="chat-text">Yoooho</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat8')"></div>
            <div class="chat-content">
              <div class="chat-username">4***1</div>
              <div class="chat-text">Fakhi u nayini🔥</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">6</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat9')"></div>
            <div class="chat-content">
              <div class="chat-username">3***0</div>
              <div class="chat-text">Mxm</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">5</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat10')"></div>
            <div class="chat-content">
              <div class="chat-username">2***3</div>
              <div class="chat-text">yazin this thing</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">5</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat11')"></div>
            <div class="chat-content">
              <div class="chat-username">3***3</div>
              <div class="chat-text">Wish</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">7</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat12')"></div>
            <div class="chat-content">
              <div class="chat-username">3***3</div>
              <div class="chat-text">Atleast</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat13')"></div>
            <div class="chat-content">
              <div class="chat-username">5***6</div>
              <div class="chat-text">Ku ubl</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat14')"></div>
            <div class="chat-content">
              <div class="chat-username">1***7</div>
              <div class="chat-text">Senzeni sixolise</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">14</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat15')"></div>
            <div class="chat-content">
              <div class="chat-username">3***0</div>
              <div class="chat-text">Stageout</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">2</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat16')"></div>
            <div class="chat-content">
              <div class="chat-username">1***2</div>
              <div class="chat-text">Come and recover</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">5</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat17')"></div>
            <div class="chat-content">
              <div class="chat-username">3***9</div>
              <div class="chat-text">Oooh</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">2</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat18')"></div>
            <div class="chat-content">
              <div class="chat-username">2***4</div>
              <div class="chat-text">sto on pink</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">2</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat19')"></div>
            <div class="chat-content">
              <div class="chat-username">1***0</div>
              <div class="chat-text">I need 2mil</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat20')"></div>
            <div class="chat-content">
              <div class="chat-username">8***1</div>
              <div class="chat-text">Lol</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">4</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat21')"></div>
            <div class="chat-content">
              <div class="chat-username">1***2</div>
              <div class="chat-text">Prediction please please guys</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">1</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
          
          <div class="chat-message">
            <div class="avatar" style="background-image: url('https://i.pravatar.cc/20?u=chat22')"></div>
            <div class="chat-content">
              <div class="chat-username">3***9</div>
              <div class="chat-text">Another one</div>
            </div>
            <div class="chat-reactions">
              <span class="chat-like-count">1</span>
              <button class="chat-like-btn">👍</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <audio id="bgMusic" loop src="<?php echo e(asset('assets/bg_music.mp3')); ?>"></audio>
  <audio id="spriteAudio" src="<?php echo e(asset('assets/sprite_audio.mp3')); ?>"></audio>
  <script src="<?php echo e(asset('js/script.js')); ?>"></script>
  <script src="<?php echo e(asset('js/buttonscript.js')); ?>"></script>
  <div id="notification-container"></div>

  <?php if(auth()->guard()->check()): ?>
  <!-- Modals -->
  <?php echo $__env->make('modals.topup', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.profile', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.withdraw', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.history', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.logout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.payment-success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.how-to-play', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('modals.game-rules', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php endif; ?>

  <script>
    // User menu dropdown and modal functionality
    document.addEventListener('DOMContentLoaded', function() {
      const menuIcon = document.getElementById('userMenuIcon');
      const dropdown = document.getElementById('userMenuDropdown');
      
      if (menuIcon && dropdown) {
        menuIcon.addEventListener('click', function(e) {
          e.stopPropagation();
          dropdown.classList.toggle('active');
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
          if (!menuIcon.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.remove('active');
          }
        });
      }
      
      // Global modal functions
      window.openModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) {
          modal.classList.add('active');
          document.body.style.overflow = 'hidden';
          // Close dropdown when opening modal
          if (dropdown) dropdown.classList.remove('active');
        }
      };
      
      window.closeModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) {
          modal.classList.remove('active');
          document.body.style.overflow = '';
        }
      };
      
      // Close modals when clicking overlay
      document.querySelectorAll('.modal-overlay').forEach(overlay => {
        overlay.addEventListener('click', function(e) {
          if (e.target === overlay) {
            const modal = overlay.closest('.modal');
            if (modal) {
              closeModal(modal.id);
            }
          }
        });
      });
      
      // Close modals with Escape key
      document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
          document.querySelectorAll('.modal.active').forEach(modal => {
            closeModal(modal.id);
          });
        }
      });
      
      // Toggle switches functionality
      const soundToggle = document.getElementById('soundToggle');
      const musicToggle = document.getElementById('musicToggle');
      const animationToggle = document.getElementById('animationToggle');
      
      if (soundToggle) {
        soundToggle.addEventListener('change', function() {
          // Store preference in localStorage
          localStorage.setItem('soundEnabled', this.checked);
          // Toggle sprite audio
          const spriteAudio = document.getElementById('spriteAudio');
          if (spriteAudio) {
            if (this.checked) {
              spriteAudio.volume = 1;
            } else {
              spriteAudio.volume = 0;
            }
          }
        });
        // Load saved preference
        const soundEnabled = localStorage.getItem('soundEnabled');
        if (soundEnabled !== null) {
          soundToggle.checked = soundEnabled === 'true';
        }
      }
      
      if (musicToggle) {
        musicToggle.addEventListener('change', function() {
          localStorage.setItem('musicEnabled', this.checked);
          // Toggle background music
          const bgMusic = document.getElementById('bgMusic');
          if (bgMusic) {
            if (this.checked) {
              bgMusic.volume = 0.3;
              bgMusic.play().catch(e => console.log('Music play prevented'));
            } else {
              bgMusic.pause();
              bgMusic.volume = 0;
            }
          }
        });
        // Load saved preference
        const musicEnabled = localStorage.getItem('musicEnabled');
        if (musicEnabled !== null) {
          musicToggle.checked = musicEnabled === 'true';
        }
      }
      
      if (animationToggle) {
        animationToggle.addEventListener('change', function() {
          localStorage.setItem('animationEnabled', this.checked);
          // Toggle animations (can add more specific animation controls later)
          document.body.classList.toggle('animations-disabled', !this.checked);
        });
        // Load saved preference
        const animationEnabled = localStorage.getItem('animationEnabled');
        if (animationEnabled !== null) {
          animationToggle.checked = animationEnabled === 'true';
        }
      }
    });
  </script>
</body>
</html>
<?php /**PATH C:\Users\aduam\Documents\GitHub\aviator_clone_complete\upgrade\aviator_crash\resources\views/game.blade.php ENDPATH**/ ?>