<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>Admin - @yield('title', 'Dashboard')</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    :root {
      --brand-red: #e60026;
      --brand-green: #12DF38;
      --brand-blue: #3b82f6;
      --brand-purple: #a855f7;
      --brand-yellow: #eab308;
      --bg-darker: #0a0a0a;
      --bg-dark: #1a1a1a;
      --bg-med: #262626;
      --bg-light: #2d2d2d;
      --text-primary: #ffffff;
      --text-secondary: #888888;
      --border-color: #3a3a3a;
      --shadow: rgba(0, 0, 0, 0.3);
    }

    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background-color: var(--bg-darker);
      color: #ffffff;
      line-height: 1.6;
    }

    .admin-layout {
      display: flex;
      min-height: 100vh;
    }

    .admin-sidebar {
      width: 280px;
      background: var(--bg-dark);
      border-right: 1px solid var(--border-color);
      padding: 0;
      position: fixed;
      height: 100vh;
      overflow-y: auto;
      box-shadow: 4px 0 20px var(--shadow);
      z-index: 100;
    }

    .admin-sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .admin-sidebar::-webkit-scrollbar-track {
      background: var(--bg-darker);
    }

    .admin-sidebar::-webkit-scrollbar-thumb {
      background: var(--bg-med);
      border-radius: 3px;
    }

    .admin-logo {
      font-size: 24px;
      font-weight: 800;
      color: var(--brand-green);
      margin-bottom: 0;
      padding: 28px 24px;
      border-bottom: 1px solid var(--border-color);
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .admin-logo i {
      font-size: 28px;
      color: var(--brand-red);
    }

    .admin-nav {
      list-style: none;
      padding: 24px 16px;
    }

    .admin-nav li {
      margin-bottom: 4px;
    }

    .admin-nav a {
      display: flex;
      align-items: center;
      padding: 14px 16px;
      color: var(--text-secondary);
      text-decoration: none;
      border-radius: 12px;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      font-weight: 500;
      font-size: 14px;
    }

    .admin-nav a:hover {
      background-color: var(--bg-med);
      color: var(--text-primary);
      transform: translateX(4px);
    }

    .admin-nav a.active {
      background: linear-gradient(135deg, var(--brand-red) 0%, var(--brand-red) 100%);
      color: #ffffff;
      box-shadow: 0 4px 12px rgba(230, 0, 38, 0.3);
    }

    .admin-nav-icon {
      width: 24px;
      height: 24px;
      margin-right: 14px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 16px;
    }

    .admin-main {
      flex: 1;
      margin-left: 280px;
      padding: 32px;
      background: var(--bg-darker);
    }

    .admin-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 32px;
      padding: 24px 32px;
      background: var(--bg-dark);
      border-radius: 16px;
      box-shadow: 0 4px 6px -1px var(--shadow);
      border: 1px solid var(--border-color);
    }

    .admin-title {
      font-size: 32px;
      font-weight: 700;
      background: linear-gradient(135deg, #ffffff 0%, var(--text-secondary) 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }

    .admin-user {
      display: flex;
      align-items: center;
      gap: 14px;
      padding: 10px 20px;
      background: linear-gradient(135deg, var(--brand-green) 0%, #0eb830 100%);
      border-radius: 12px;
      color: #ffffff;
      font-weight: 600;
      box-shadow: 0 4px 12px rgba(18, 223, 56, 0.3);
    }

    .admin-user-name {
      font-weight: 600;
      font-size: 14px;
    }

    .btn {
      padding: 12px 24px;
      border: none;
      border-radius: 10px;
      cursor: pointer;
      font-weight: 600;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      font-size: 14px;
      box-shadow: 0 2px 8px var(--shadow);
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 16px var(--shadow);
    }

    .btn:active {
      transform: translateY(0);
    }

    .btn-primary {
      background: linear-gradient(135deg, var(--brand-green) 0%, #0eb830 100%);
      color: #ffffff;
    }

    .btn-primary:hover {
      background: linear-gradient(135deg, #0eb830 0%, var(--brand-green) 100%);
    }

    .btn-danger {
      background: linear-gradient(135deg, var(--brand-red) 0%, #cc0022 100%);
      color: #ffffff;
    }

    .btn-danger:hover {
      background: linear-gradient(135deg, #cc0022 0%, var(--brand-red) 100%);
    }

    .btn-success {
      background: linear-gradient(135deg, var(--brand-green) 0%, #0eb830 100%);
      color: #ffffff;
    }

    .btn-success:hover {
      background: linear-gradient(135deg, #0eb830 0%, var(--brand-green) 100%);
    }

    .btn-sm {
      padding: 8px 16px;
      font-size: 13px;
    }

    .card {
      background: var(--bg-dark);
      border-radius: 16px;
      padding: 28px;
      margin-bottom: 24px;
      border: 1px solid var(--border-color);
      box-shadow: 0 4px 6px -1px var(--shadow);
      transition: all 0.3s ease;
    }

    .card:hover {
      box-shadow: 0 10px 20px -2px var(--shadow);
      transform: translateY(-2px);
    }

    .card-title {
      font-size: 20px;
      font-weight: 700;
      margin-bottom: 20px;
      color: var(--text-primary);
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .card-title i {
      color: var(--brand-green);
    }

    .stats-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
      gap: 24px;
      margin-bottom: 32px;
    }

    .stat-card {
      background: var(--bg-dark);
      border-radius: 16px;
      padding: 28px;
      border: 1px solid var(--border-color);
      box-shadow: 0 4px 6px -1px var(--shadow);
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .stat-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, var(--brand-green) 0%, var(--brand-green) 100%);
    }

    .stat-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 12px 24px -4px var(--shadow);
    }

    .stat-label {
      color: var(--text-secondary);
      font-size: 13px;
      font-weight: 600;
      margin-bottom: 12px;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    .stat-label i {
      margin-right: 8px;
    }

    .stat-value {
      font-size: 36px;
      font-weight: 800;
      background: linear-gradient(135deg, var(--brand-green) 0%, #ffffff 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }

    .table-container {
      overflow-x: auto;
      border-radius: 12px;
      box-shadow: 0 2px 8px var(--shadow);
    }

    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0;
      background: var(--bg-med);
      border-radius: 12px;
      overflow: hidden;
    }

    thead {
      background: linear-gradient(135deg, var(--bg-light) 0%, var(--bg-med) 100%);
    }

    th {
      color: var(--text-primary);
      padding: 16px 20px;
      text-align: left;
      font-weight: 600;
      font-size: 13px;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }

    td {
      padding: 16px 20px;
      border-bottom: 1px solid var(--border-color);
      font-size: 14px;
      color: var(--text-primary);
    }

    tbody tr:hover td {
      background-color: var(--bg-light);
    }

    tbody tr:last-child td {
      border-bottom: none;
    }

    /* Tab Navigation */
    .tab-nav {
      display: flex;
      background: var(--bg-med);
      border-radius: 12px;
      padding: 6px;
      gap: 8px;
      margin-bottom: 24px;
    }

    .tab-btn {
      flex: 1;
      padding: 14px 24px;
      background: transparent;
      border: none;
      border-radius: 10px;
      color: var(--text-secondary);
      cursor: pointer;
      font-size: 14px;
      font-weight: 500;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      text-align: center;
    }

    .tab-btn:hover {
      background: var(--bg-light);
      color: var(--text-primary);
    }

    .tab-btn.active {
      background: linear-gradient(135deg, var(--brand-green) 0%, #0eb830 100%);
      color: #ffffff;
      font-weight: 600;
      box-shadow: 0 4px 12px rgba(18, 223, 56, 0.3);
    }

    .tab-content {
      display: none;
    }

    .tab-content.active {
      display: block;
    }

    .status-badge {
      display: inline-flex;
      align-items: center;
      gap: 6px;
      padding: 6px 14px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.3px;
    }

    .status-badge i {
      font-size: 10px;
    }

    .status-success {
      background: linear-gradient(135deg, rgba(18, 223, 56, 0.2) 0%, rgba(18, 223, 56, 0.1) 100%);
      color: var(--brand-green);
      border: 1px solid rgba(18, 223, 56, 0.3);
    }

    .status-pending {
      background: linear-gradient(135deg, rgba(234, 179, 8, 0.2) 0%, rgba(234, 179, 8, 0.1) 100%);
      color: var(--brand-yellow);
      border: 1px solid rgba(234, 179, 8, 0.3);
    }

    .status-error {
      background: linear-gradient(135deg, rgba(230, 0, 38, 0.2) 0%, rgba(230, 0, 38, 0.1) 100%);
      color: var(--brand-red);
      border: 1px solid rgba(230, 0, 38, 0.3);
    }

    .alert {
      padding: 18px 24px;
      border-radius: 12px;
      margin-bottom: 24px;
      font-weight: 500;
      display: flex;
      align-items: center;
      gap: 12px;
      font-size: 14px;
    }

    .alert i {
      font-size: 20px;
    }

    .alert-success {
      background: linear-gradient(135deg, rgba(18, 223, 56, 0.15) 0%, rgba(18, 223, 56, 0.05) 100%);
      color: var(--brand-green);
      border: 1px solid rgba(18, 223, 56, 0.3);
    }

    .alert-error {
      background: linear-gradient(135deg, rgba(230, 0, 38, 0.15) 0%, rgba(230, 0, 38, 0.05) 100%);
      color: var(--brand-red);
      border: 1px solid rgba(230, 0, 38, 0.3);
    }

    @media (max-width: 1024px) {
      .admin-sidebar {
        display: none;
      }

      .admin-main {
        margin-left: 0;
        padding: 20px;
      }

      .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
      }
    }
  </style>
</head>
<body>
  <div class="admin-layout">
    <!-- Sidebar -->
    <aside class="admin-sidebar">
      <div class="admin-logo">
        <i class="fas fa-gamepad"></i>
        Admin Panel
      </div>
      <ul class="admin-nav">
        <li>
          <a href="{{ route('admin.dashboard') }}" class="{{ request()->is('admin') ? 'active' : '' }}">
            <span class="admin-nav-icon"><i class="fas fa-chart-line"></i></span>
            Dashboard
          </a>
        </li>
        <li>
          <a href="{{ route('admin.users') }}" class="{{ request()->is('admin/users*') ? 'active' : '' }}">
            <span class="admin-nav-icon"><i class="fas fa-users"></i></span>
            Users
          </a>
        </li>
        <li>
          <a href="{{ route('admin.finances') }}" class="{{ request()->is('admin/finances*') ? 'active' : '' }}">
            <span class="admin-nav-icon"><i class="fas fa-wallet"></i></span>
            Finances
          </a>
        </li>
        <li>
          <a href="{{ route('admin.settings') }}" class="{{ request()->is('admin/settings*') ? 'active' : '' }}">
            <span class="admin-nav-icon"><i class="fas fa-cog"></i></span>
            Settings
          </a>
        </li>
        <li>
          <a href="{{ route('game') }}" class="">
            <span class="admin-nav-icon"><i class="fas fa-play-circle"></i></span>
            Game
          </a>
        </li>
        <li>
          <a href="{{ route('admin.logout') }}" class="">
            <span class="admin-nav-icon"><i class="fas fa-sign-out-alt"></i></span>
            Logout
          </a>
        </li>
      </ul>
    </aside>

    <!-- Main Content -->
    <main class="admin-main">
      <header class="admin-header">
        <h1 class="admin-title">@yield('title', 'Dashboard')</h1>
        <div class="admin-user">
          <i class="fas fa-user-circle"></i>
          <span class="admin-user-name">{{ Auth::user()->name }}</span>
        </div>
      </header>

      @if(session('success'))
        <div class="alert alert-success">
          <i class="fas fa-check-circle"></i>
          {{ session('success') }}
        </div>
      @endif

      @if(session('error'))
        <div class="alert alert-error">
          <i class="fas fa-exclamation-circle"></i>
          {{ session('error') }}
        </div>
      @endif

      @yield('content')
    </main>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
  @stack('scripts')
</body>
</html>
