@extends('layouts.admin')

@section('title', 'Users')

@section('content')
  <div class="card">
    <div class="card-title"><i class="fas fa-users"></i> All Users</div>
    <div class="table-container">
      <table>
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Balance</th>
            <th>Role</th>
            <th>Banned</th>
            <th>Status</th>
            <th>Joined</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($users as $user)
            <tr>
              <td>#{{ $user->id }}</td>
              <td>{{ $user->name }}</td>
              <td>{{ $user->email }}</td>
              <td>{{ $user->phone ?? '-' }}</td>
              <td>R$ {{ number_format($user->balance, 2, ',', '.') }}</td>
              <td>
                @if($user->role_id == 1)
                  <span class="status-badge status-success"><i class="fas fa-user-shield"></i> Admin</span>
                @else
                  <span class="status-badge status-pending"><i class="fas fa-user"></i> User</span>
                @endif
              </td>
              <td>
                @if($user->banned)
                  <span class="status-badge status-error"><i class="fas fa-ban"></i> Yes</span>
                @else
                  <span class="status-badge status-success"><i class="fas fa-check"></i> No</span>
                @endif
              </td>
              <td>
                @if($user->status)
                  <span class="status-badge status-success"><i class="fas fa-check-circle"></i> Active</span>
                @else
                  <span class="status-badge status-error"><i class="fas fa-times-circle"></i> Inactive</span>
                @endif
              </td>
              <td>{{ $user->created_at->format('M d, Y') }}</td>
              <td>
                <a href="{{ route('admin.users.show', $user->id) }}" class="btn btn-sm btn-primary">
                  <i class="fas fa-eye"></i> View
                </a>
                <form action="{{ route('admin.users.ban', $user->id) }}" method="POST" style="display: inline;">
                  @csrf
                  @method('PATCH')
                  <button type="submit" class="btn btn-sm {{ $user->banned ? 'btn-success' : 'btn-danger' }}">
                    <i class="fas fa-{{ $user->banned ? 'unlock' : 'ban' }}"></i> {{ $user->banned ? 'Unban' : 'Ban' }}
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="10">No users found</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
    
    @if($users->hasPages())
      <div style="margin-top: 20px; text-align: center;">
        {{ $users->links() }}
      </div>
    @endif
  </div>
@endsection
