@extends('layouts.admin')

@section('title', 'Statistics')

@section('content')
  <!-- Game Stats -->
  <div class="stats-grid">
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-gamepad"></i> Total Rounds</div>
      <div class="stat-value">{{ $totalRounds }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-dice"></i> Average Multiplier</div>
      <div class="stat-value">{{ number_format($avgMultiplier, 2, ',', '.') }}x</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-trophy"></i> Highest Multiplier</div>
      <div class="stat-value">{{ number_format($highestMultiplier, 2, ',', '.') }}x</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-users"></i> Active Players</div>
      <div class="stat-value">{{ $activeUsers }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-coins"></i> Total Bets</div>
      <div class="stat-value">{{ $totalBets }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-chart-line"></i> Total Won</div>
      <div class="stat-value">{{ $totalWins }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-times-circle"></i> Total Lost</div>
      <div class="stat-value">{{ $totalLosses }}</div>
    </div>
    <div class="stat-card">
      <div class="stat-label"><i class="fas fa-percentage"></i> Win Rate</div>
      <div class="stat-value">
        @if($totalBets > 0)
          {{ number_format(($totalWins / $totalBets) * 100, 1, ',', '.') }}%
        @else
          0%
        @endif
      </div>
    </div>
  </div>

  <!-- Tabbed Table Card -->
  <div class="card">
    <!-- Tab Navigation -->
    <div class="tab-nav">
      <button class="tab-btn active" data-tab="recent-rounds" onclick="switchTab('recent-rounds', this)">
        <i class="fas fa-history"></i> Recent Rounds
      </button>
      <button class="tab-btn" data-tab="top-winners" onclick="switchTab('top-winners', this)">
        <i class="fas fa-medal"></i> Top Winners
      </button>
    </div>

    <!-- Recent Rounds Tab -->
    <div id="recent-rounds" class="tab-content active">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>ID</th>
              <th>Multiplier</th>
              <th>Winner</th>
              <th>Won Amount</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            @forelse($recentRounds as $round)
              <tr>
                <td>#{{ $round->id }}</td>
                <td>
                  <span class="status-badge status-success">{{ number_format($round->multiplier, 2, ',', '.') }}x</span>
                </td>
                <td>{{ $round->winner_name ?? '-' }}</td>
                <td>
                  @if($round->won_amount)
                    R$ {{ number_format($round->won_amount, 2, ',', '.') }}
                  @else
                    -
                  @endif
                </td>
                <td>{{ $round->created_at->format('M d, Y H:i') }}</td>
              </tr>
            @empty
              <tr>
                <td colspan="5">No rounds found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      
    </div>

    <!-- Top Winners Tab -->
    <div id="top-winners" class="tab-content">
      <div class="table-container">
        <table>
          <thead>
            <tr>
              <th>Rank</th>
              <th>User</th>
              <th>Total Won</th>
              <th>Total Bets</th>
              <th>Win Rate</th>
            </tr>
          </thead>
          <tbody>
            @forelse($topWinners as $index => $winner)
              <tr>
                <td>
                  @if($index == 0)
                    <i class="fas fa-trophy" style="color: #FFD700; font-size: 20px;"></i>
                  @elseif($index == 1)
                    <i class="fas fa-trophy" style="color: #C0C0C0; font-size: 18px;"></i>
                  @elseif($index == 2)
                    <i class="fas fa-trophy" style="color: #CD7F32; font-size: 16px;"></i>
                  @else
                    #{{ $index + 1 }}
                  @endif
                </td>
                <td>{{ $winner->name ?? 'Unknown' }}</td>
                <td class="status-badge status-success">R$ {{ number_format($winner->total_wins, 2, ',', '.') }}</td>
                <td>-</td>
                <td>-</td>
              </tr>
            @empty
              <tr>
                <td colspan="5">No winners found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
      
    </div>
  </div>

  <script>
    function switchTab(tabId, button) {
      document.querySelectorAll('.tab-content').forEach(function(content) {
        content.classList.remove('active');
      });

      document.querySelectorAll('.tab-btn').forEach(function(btn) {
        btn.classList.remove('active');
      });

      document.getElementById(tabId).classList.add('active');
      button.classList.add('active');
    }
  </script>
@endsection
