/**
 * Settings Module
 * Handles user preferences (sound, music, animation)
 */

export function initSettings() {
  const soundToggle = document.getElementById('soundToggle');
  const musicToggle = document.getElementById('musicToggle');
  const animationToggle = document.getElementById('animationToggle');
  
  if (soundToggle) {
    soundToggle.addEventListener('change', function() {
      localStorage.setItem('soundEnabled', this.checked);
      const spriteAudio = document.getElementById('spriteAudio');
      if (spriteAudio) {
        spriteAudio.volume = this.checked ? 1 : 0;
      }
    });
    
    const soundEnabled = localStorage.getItem('soundEnabled');
    if (soundEnabled !== null) {
      soundToggle.checked = soundEnabled === 'true';
    }
  }
  
  if (musicToggle) {
    musicToggle.addEventListener('change', function() {
      localStorage.setItem('musicEnabled', this.checked);
      const bgMusic = document.getElementById('bgMusic');
      if (bgMusic) {
        if (this.checked) {
          bgMusic.volume = 0.3;
          bgMusic.play().catch(e => console.log('Music play prevented'));
        } else {
          bgMusic.pause();
          bgMusic.volume = 0;
        }
      }
    });
    
    const musicEnabled = localStorage.getItem('musicEnabled');
    if (musicEnabled !== null) {
      musicToggle.checked = musicEnabled === 'true';
    }
  }
  
  if (animationToggle) {
    animationToggle.addEventListener('change', function() {
      localStorage.setItem('animationEnabled', this.checked);
      document.body.classList.toggle('animations-disabled', !this.checked);
    });
    
    const animationEnabled = localStorage.getItem('animationEnabled');
    if (animationEnabled !== null) {
      animationToggle.checked = animationEnabled === 'true';
    }
  }
}
