// Button functionality for betting interface
const amtEl = document.querySelectorAll('.bet-amount');
const btnAmtEl = document.querySelectorAll('.bet-btn-amount');

function updateDisplay(index, val) {
  if (amtEl[index] && btnAmtEl[index]) {
    amtEl[index].textContent = val.toFixed(2);
    btnAmtEl[index].textContent = val.toFixed(2) + ' ZAR';
  }
}

function changeBet(delta) {
  // find which panel triggered this
  const controlBtns = document.querySelectorAll('.control-btn');
  const idx = Math.floor(Array.from(controlBtns).indexOf(event.currentTarget) / 2);
  if (idx >= 0 && amtEl[idx]) {
    let val = parseFloat(amtEl[idx].textContent) + delta;
    if (val < 1) val = 1;
    updateDisplay(idx, val);
  }
}

function setBet(x) {
  // same logic to detect panel index
  const quickBets = document.querySelectorAll('.quick-bet');
  const idx = Math.floor(Array.from(quickBets).indexOf(event.currentTarget) / 4);
  if (idx >= 0) {
    updateDisplay(idx, x);
  }
}

// tab switching
document.querySelectorAll('.betting-panel').forEach((panel, idx) => {
  panel.querySelectorAll('.tab').forEach(tab => {
    tab.addEventListener('click', () => {
      panel.querySelectorAll('.tab').forEach(t => {
        t.classList.toggle('active', t === tab);
        t.classList.toggle('inactive', t !== tab);
      });
    });
  });
});

// Initialize display values when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
  amtEl.forEach((el, idx) => {
    if (el && btnAmtEl[idx]) {
      const val = parseFloat(el.textContent) || 2.00;
      updateDisplay(idx, val);
    }
  });
});