<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

return new class extends Migration
{
    /**
     * Run the migrations.
     * This migration imports the lopixbet.sql file into the database.
     * Note: This requires the SQL file to be present in the project root.
     */
    public function up(): void
    {
        $sqlFile = base_path('lopixbet.sql');
        
        if (!File::exists($sqlFile)) {
            throw new \Exception("SQL file not found: {$sqlFile}");
        }

        // Read the SQL file
        $sql = File::get($sqlFile);

        // Remove comments and empty lines that might cause issues
        $sql = preg_replace('/--.*$/m', '', $sql);
        $sql = preg_replace('/\/\*.*?\*\//s', '', $sql);

        // Split by semicolons but keep multi-line statements intact
        $statements = array_filter(
            array_map('trim', explode(';', $sql)),
            function ($statement) {
                return !empty($statement) && strlen($statement) > 10;
            }
        );

        // Execute each statement
        foreach ($statements as $statement) {
            try {
                DB::unprepared($statement);
            } catch (\Exception $e) {
                // Log error but continue with other statements
                \Log::warning("SQL import error: " . $e->getMessage());
            }
        }
    }

    /**
     * Reverse the migrations.
     * Note: This is a destructive operation - use with caution!
     */
    public function down(): void
    {
        // Optionally drop imported tables here
        // For safety, we'll leave this empty
    }
};
