<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class GameRound extends Model
{
    protected $fillable = [
        'round_id',
        'user_id',
        'multiplier',
        'bet_amount',
        'win_amount',
        'result',
        'started_at',
        'ended_at',
    ];

    protected $casts = [
        'multiplier' => 'decimal:2',
        'bet_amount' => 'decimal:2',
        'win_amount' => 'decimal:2',
        'started_at' => 'datetime',
        'ended_at' => 'datetime',
    ];

    /**
     * Get the user that played this round.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
