<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => DB::table('users')->count(),
            'active_users' => DB::table('users')
                ->where('last_activity', '>=', now()->subHours(24))
                ->count(),
            'total_deposits' => DB::table('deposits')
                ->where('status', 1)
                ->sum('amount'),
            'total_withdrawals' => DB::table('orders')
                ->where('type_money', 'balance_withdrawal')
                ->where('status', 1)
                ->sum('amount'),
            'pending_deposits' => DB::table('deposits')
                ->where('status', 0)
                ->count(),
            'pending_withdrawals' => DB::table('orders')
                ->where('type_money', 'balance_withdrawal')
                ->where('status', 0)
                ->count(),
            'total_game_rounds' => DB::table('game_rounds')->count(),
            'total_revenue' => DB::table('orders')
                ->where('type', 'loss')
                ->where('type_money', 'balance_withdrawal')
                ->where('status', 1)
                ->sum('amount') - DB::table('orders')
                ->where('type', 'win')
                ->where('type_money', 'balance_withdrawal')
                ->where('status', 1)
                ->sum('amount'),
        ];

        $recent_users = DB::table('users')
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get(['id', 'name', 'email', 'created_at'])
            ->map(function ($user) {
                $user->created_at = Carbon::parse($user->created_at);
                return $user;
            });

        $recent_deposits = DB::table('deposits')
            ->join('users', 'deposits.user_id', '=', 'users.id')
            ->orderBy('deposits.created_at', 'desc')
            ->limit(10)
            ->get([
                'deposits.id',
                'users.name',
                'deposits.amount',
                'deposits.status',
                'deposits.created_at'
            ])
            ->map(function ($deposit) {
                $deposit->created_at = Carbon::parse($deposit->created_at);
                return $deposit;
            });

        $recent_withdrawals = DB::table('orders')
            ->join('users', 'orders.user_id', '=', 'users.id')
            ->where('orders.type_money', 'balance_withdrawal')
            ->orderBy('orders.created_at', 'desc')
            ->limit(10)
            ->get([
                'orders.id',
                'users.name',
                'orders.amount',
                'orders.status',
                'orders.created_at'
            ])
            ->map(function ($withdrawal) {
                $withdrawal->created_at = Carbon::parse($withdrawal->created_at);
                return $withdrawal;
            });

        return view('admin.dashboard', compact(
            'stats',
            'recent_users',
            'recent_deposits',
            'recent_withdrawals'
        ));
    }
}
