# Database Import Instructions

## Importing lopixbet.sql into MySQL

To import the `lopixbet.sql` file into your MySQL database:

### Option 1: Using MySQL Command Line

```bash
# Navigate to the aviator_crash directory
cd aviator_crash

# Import the SQL file (replace root/password with your MySQL credentials)
mysql -u root -p aviator_crash < lopixbet.sql
```

### Option 2: Using phpMyAdmin

1. Open phpMyAdmin in your browser
2. Select the `aviator_crash` database
3. Click on the "Import" tab
4. Click "Choose File" and select `lopixbet.sql`
5. Click "Go" to import

### Option 3: Using Laravel Migration (Automatic)

```bash
cd aviator_crash
php artisan migrate
```

This will run the migration that imports the SQL file automatically.

### Verify Import

After importing, verify that the tables were created:

```bash
mysql -u root -p aviator_crash -e "SHOW TABLES;"
```

You should see tables like:
- users
- orders
- deposits
- games
- And many more...

### Important Notes

- Make sure your `.env` file has the correct database credentials
- The database `aviator_crash` must exist before importing
- The SQL file contains data, so existing data might be overwritten
- After import, run Laravel migrations to ensure compatibility: `php artisan migrate`
